/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.downloadmgr;

import com.adventnet.sym.server.downloadmgr.DownloadManager;
import com.adventnet.sym.server.downloadmgr.DownloadStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DCDownloadMgrProxyServer {
    static DownloadManager dwnManager = null;
    static int success = 0;
    static int fail = 0;

    public static void main(String[] args) {
        try {
            DCDownloadMgrProxyServer proxyserver = new DCDownloadMgrProxyServer();
            if (args.length == 0 || args.length % 2 == 1) {
                proxyserver.displayHelp();
                return;
            }
            if (args.length == 2) {
                if (!args[0].equals("-c")) {
                    proxyserver.displayHelp();
                    return;
                }
            } else if (args.length == 4 && !args[2].equals("-f")) {
                proxyserver.displayHelp();
                return;
            }
            dwnManager = DownloadManager.getInstance();
            Properties proxyProperties = proxyserver.loadProxySettings();
            if (args[1].equalsIgnoreCase("updatedb")) {
                if (proxyProperties != null) {
                    proxyserver.processUpdateDBRequest();
                }
            } else if (args[1].equalsIgnoreCase("dwnpatch")) {
                String fileName = args[3];
                JSONObject requestObject = proxyserver.loadDownloadJson(fileName);
                if (requestObject != null) {
                    JSONArray jsonArray = requestObject.getJSONArray("data");
                    if (jsonArray.length() > 0) {
                        System.out.println("Total Number of patches  is :: " + jsonArray.length());
                        File f = new File("downloadRemarks.txt");
                        if (f.exists() && f.isFile()) {
                            f.delete();
                        }
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            System.out.println("Counter  :: " + (i + 1));
                            JSONObject request = jsonArray.getJSONObject(i);
                            proxyserver.processDownloadRequest(request);
                        }
                        if (fail > 0) {
                            System.out.println("Download status : success == ::" + success + " and fail is:: " + fail);
                            System.out.println("Download Failed Details will be available in downloadRemarks.txt");
                        }
                    } else {
                        System.out.println("No Patches to download,proceed for deployment");
                    }
                }
            } else {
                proxyserver.displayHelp();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void displayHelp() {
        System.out.println("Command Usage : patchsync.bat -c updatedb");
        System.out.println("Command Usage : patchsync.bat -c dwnpatch -f downloadUrlJson.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProxySettings() {
        Properties proxyProperties = null;
        FileInputStream pis = null;
        String proxyFileName = "downloadMgr.prop";
        try {
            if (new File(proxyFileName).exists()) {
                pis = new FileInputStream(proxyFileName);
                proxyProperties = new Properties();
                proxyProperties.load(pis);
                dwnManager.setProxyConfiguration(proxyProperties);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return proxyProperties;
    }

    private JSONObject loadDownloadJson(String jsonFileName) throws Exception {
        JSONObject requestObject = null;
        try {
            FileInputStream fis = null;
            byte[] content = null;
            try {
                if (new File(jsonFileName).exists()) {
                    fis = new FileInputStream(jsonFileName);
                    content = new byte[fis.available()];
                    fis.read(content);
                    String jsonString = new String(content);
                    requestObject = new JSONObject(jsonString);
                } else {
                    System.out.println("Command Usage :Enter Valid File");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return requestObject;
    }

    private JSONObject loadUpdateDBJson() throws Exception {
        JSONObject requestObject = null;
        try {
            String jsonFileName = "updateDBJson.txt";
            FileInputStream fis = null;
            byte[] content = null;
            try {
                if (new File(jsonFileName).exists()) {
                    fis = new FileInputStream(jsonFileName);
                    content = new byte[fis.available()];
                    fis.read(content);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            String jsonString = new String(content);
            requestObject = new JSONObject(jsonString);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return requestObject;
    }

    public void processUpdateDBRequest() {
        try {
            String crsUrl = "http://patchdb.manageengine.com/";
            String downloadUrl = crsUrl + "dc-crs/crs-meta-data.xml";
            String destinationFile = "updatedb" + File.separator + "dc-crs" + File.separator + "crs-meta-data.xml";
            DownloadStatus dwnStatus = dwnManager.downloadFile(downloadUrl, destinationFile);
            if (dwnStatus.getStatus() == 0) {
                File mainMetaFile = new File(destinationFile);
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                Document doc = builder.parse(mainMetaFile);
                XPath xpath = XPathFactory.newInstance().newXPath();
                String expression = "//CRSMetaData";
                XPathExpression expr = xpath.compile(expression);
                Object result = expr.evaluate(doc, XPathConstants.NODESET);
                NodeList nodeList = (NodeList)result;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String destinationDetailsFile;
                    String defDetailsUrl;
                    Node nodes = nodeList.item(i);
                    NamedNodeMap attributes = nodes.getAttributes();
                    String crsFilePath = attributes.getNamedItem("crs_meta_data_file_path").getNodeValue();
                    String crsFileName = attributes.getNamedItem("crs_meta_data_file_name").getNodeValue();
                    Boolean isReqFile = Boolean.TRUE;
                    ArrayList<String> unwantedFilesList = new ArrayList<String>();
                    unwantedFilesList.add("software-details.xml");
                    unwantedFilesList.add("software-package.xml");
                    unwantedFilesList.add("script-repository.xml");
                    if (unwantedFilesList.contains(crsFileName)) {
                        isReqFile = Boolean.FALSE;
                    }
                    if (!isReqFile.booleanValue() || (dwnStatus = dwnManager.downloadFile(defDetailsUrl = crsUrl + "/" + crsFilePath + "/" + crsFileName, destinationDetailsFile = "updatedb" + File.separator + crsFilePath + File.separator + crsFileName)).getStatus() != 0) continue;
                    File file = new File(destinationDetailsFile);
                    DocumentBuilder defBuilder = domFactory.newDocumentBuilder();
                    Document defDoc = defBuilder.parse(file);
                    XPath defxpath = XPathFactory.newInstance().newXPath();
                    String defExpression = "//DefinitionMetaData";
                    XPathExpression defExpr = defxpath.compile(defExpression);
                    Object defResult = defExpr.evaluate(defDoc, XPathConstants.NODESET);
                    NodeList defNodeList = (NodeList)defResult;
                    for (int j = 0; j < defNodeList.getLength(); ++j) {
                        Node defNodes = defNodeList.item(j);
                        NamedNodeMap defAttributes = defNodes.getAttributes();
                        String dataFilePath = defAttributes.getNamedItem("definition_file_path").getNodeValue();
                        String dataFileName = defAttributes.getNamedItem("definition_file_name").getNodeValue();
                        String sqlDestinationFile = "updatedb" + File.separator + dataFilePath + File.separator + dataFileName;
                        String sqlDownloadUrl = crsUrl + dataFilePath + "/" + dataFileName;
                        File testFile = new File(sqlDestinationFile);
                        if (testFile.exists()) {
                            System.out.println("File already exists, download skipped for : " + sqlDestinationFile);
                            continue;
                        }
                        dwnManager.downloadFile(sqlDownloadUrl, sqlDestinationFile);
                    }
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void processDownloadRequest(JSONObject requestObject) {
        try {
            String downloadUrl = requestObject.getString("PATH");
            String patchID = requestObject.getString("PATCHID");
            String fileName = requestObject.getString("PATCHNAME");
            String destinationFile = "store" + File.separator + patchID + "-" + fileName;
            DownloadStatus dwnStatus = dwnManager.downloadFile(downloadUrl, destinationFile);
            int statusCode = dwnStatus.getStatus();
            if (statusCode == 0) {
                ++success;
            } else {
                ++fail;
                String content = patchID + "\t" + fileName + "\t" + downloadUrl;
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File("downloadRemarks.txt"), true));
                bw.write(content);
                bw.newLine();
                bw.close();
            }
            System.out.println("Download Status : " + dwnStatus.dwnloadstatus);
            System.out.println("Download Patch Name : " + fileName);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public String extractFiles(String inputFileName) throws Exception {
        String outputFileName = null;
        String outputDir = "temp_extract";
        outputFileName = inputFileName.replaceAll(".exe", ".msp");
        String cmd = "7z e " + inputFileName + "-aoa -o" + outputDir + " *.msp -r";
        DCDownloadMgrProxyServer.execute(new String[]{"cmd.exe", "/c", cmd});
        File f = new File(outputDir);
        File[] files = f.listFiles();
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File f1 = new File(outputFileName);
                files[i].renameTo(f1);
            }
        } else {
            System.out.println("Not processed files : " + inputFileName);
        }
        return outputFileName;
    }

    public static String execute(String[] command) throws Exception {
        final StringBuffer strBuff = new StringBuffer();
        String[] cmd = command;
        try {
            InputStream consoleInput = null;
            InputStream consoleError = null;
            String readstr = "";
            final Process process = Runtime.getRuntime().exec(cmd);
            consoleInput = process.getInputStream();
            consoleError = process.getErrorStream();
            final BufferedReader readinput = new BufferedReader(new InputStreamReader(consoleInput));
            BufferedReader readerr = new BufferedReader(new InputStreamReader(consoleError));
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String readStr;
                        while ((readStr = readinput.readLine()) != null) {
                            strBuff.append(readStr);
                            strBuff.append(System.getProperty("line.separator"));
                            try {
                                if (process.exitValue() != 0) continue;
                                return;
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                            }
                        }
                    }
                    catch (IOException ioex) {
                        ioex.printStackTrace();
                    }
                }
            }, "ExecInputRead");
            th.start();
            try {
                readstr = readerr.readLine();
                if (readstr != null) {
                    System.out.println("Error while executing command----> " + readstr);
                    throw new Exception("Error while executing command " + readstr);
                }
            }
            catch (IOException io) {
                System.out.println("Input error" + io);
                throw new Exception(io.getMessage());
            }
            process.waitFor();
            th.join();
            return strBuff.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }
}

