/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.downloadmgr;

import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.CookieModule;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.NTLMAuthorizationHandler;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import com.adventnet.sym.server.downloadmgr.DCAuthorizationPrompter;
import com.adventnet.sym.server.downloadmgr.DCCookiePolicyHandler;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLUtil {
    private static Logger logger = Logger.getLogger("DownloadManager");
    private static boolean isProviderSet = false;
    private static SSLUtil sslUtil = null;

    public static SSLUtil getInstance() {
        if (sslUtil == null) {
            sslUtil = new SSLUtil();
            SSLUtil.initSSLFactory();
            SSLUtil.initSecurityProvider();
            SSLUtil.removeEncodingModule();
        }
        return sslUtil;
    }

    private static void initSecurityProvider() {
        if (!isProviderSet) {
            String string = "cryptix.jce.provider.CryptixCrypto";
            try {
                Object object;
                System.setProperty("java.protocol.handler.pkgs", "HTTPClient");
                String string2 = System.getProperty("os.name");
                InetAddress inetAddress = InetAddress.getLocalHost();
                System.setProperty("HTTPClient.host", inetAddress.getHostName());
                if (string2.indexOf("Windows") != -1) {
                    object = inetAddress.getCanonicalHostName();
                    int n = ((String)object).indexOf(46);
                    if (n != -1) {
                        object = ((String)object).substring(n + 1);
                    }
                    System.setProperty("HTTPClient.hostDomain", (String)object);
                } else {
                    System.setProperty("HTTPClient.hostDomain", "");
                }
                if (string != null) {
                    object = Class.forName(string);
                    Security.addProvider((Provider)((Class)object).newInstance());
                    logger.log(Level.INFO, "Provider :: {0}", Security.getProvider(((Provider)((Class)object).newInstance()).getName()));
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Error occurred during initializing the security providers : {0}", exception);
            }
            isProviderSet = true;
            CookieModule.setCookiePolicyHandler((CookiePolicyHandler)new DCCookiePolicyHandler());
            System.getProperties().put("java.protocol.handler.pkgs", "HTTPClient");
        }
    }

    private static void removeEncodingModule() {
        try {
            boolean bl;
            String string = System.getProperty("enable.content.encoding", null);
            if (string != null && !(bl = Boolean.valueOf(string).booleanValue())) {
                logger.log(Level.INFO, "\"enable.content.encoding\" java system property is false. Hence, removing default module : HTTPClient.ContentEncodingModule ");
                HTTPConnection.removeDefaultModule(Class.forName("HTTPClient.ContentEncodingModule"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "Exception while removing module \"HTTPClient.ContentEncodingModule\":: ", classNotFoundException);
        }
    }

    public HTTPConnection getConnection(String string, Properties properties) throws ProtocolNotSuppException, MalformedURLException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (properties != null) {
            string2 = (String)properties.get("proxyHost");
            string3 = (String)properties.get("proxyPort");
            string4 = (String)properties.get("proxyUser");
            string5 = (String)properties.get("proxyPass");
        }
        NTLMAuthorizationHandler nTLMAuthorizationHandler = new NTLMAuthorizationHandler();
        NTLMAuthorizationHandler.setAuthorizationPrompter((AuthorizationPrompter)new DCAuthorizationPrompter(string4, string5));
        AuthorizationInfo.setAuthHandler((AuthorizationHandler)nTLMAuthorizationHandler);
        DefaultAuthHandler.setAuthorizationPrompter((AuthorizationPrompter)new DCAuthorizationPrompter(string4, string5));
        URL uRL = new URL(string);
        HTTPConnection hTTPConnection = new HTTPConnection(uRL);
        hTTPConnection.setDefaultHeaders(this.getDefaultHeaders(hTTPConnection));
        if (string2 != null && string3 != null && !string2.equalsIgnoreCase("") && !string3.equalsIgnoreCase("")) {
            logger.log(Level.INFO, "Connection {0},{1},{2}", new Object[]{hTTPConnection, string2.trim(), string3.trim()});
            if (string2 != null) {
                hTTPConnection.setCurrentProxy(string2.trim(), new Integer(string3.trim()).intValue());
            }
        }
        return hTTPConnection;
    }

    private NVPair[] getDefaultHeaders(HTTPConnection hTTPConnection) {
        NVPair[] nVPairArray = hTTPConnection.getDefaultHeaders();
        NVPair nVPair = new NVPair("Cache-Control", "no-cache");
        NVPair nVPair2 = new NVPair("Accept", "*/*");
        if (nVPairArray != null) {
            if (nVPairArray.length > 0) {
                nVPairArray[nVPairArray.length + 1] = nVPair;
                nVPairArray[nVPairArray.length + 1] = nVPair2;
            } else {
                nVPairArray = new NVPair[]{nVPair, nVPair2};
            }
        }
        return nVPairArray;
    }

    private static void initSSLFactory() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
                return true;
            }

            public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
                return true;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HTTPConnection.setDefaultSSLSocketFactory((SSLSocketFactory)sSLContext.getSocketFactory());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error occurred during initializing the ssl factories : {0}", exception);
        }
    }
}

