/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.examples;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import sun.misc.BASE64Encoder;

public class FileHashing {
    private MessageDigest md = null;
    private byte[] hash_raw = null;

    public boolean run(String hashfunction, String provider, String filename) {
        boolean ret = false;
        try {
            this.md = MessageDigest.getInstance(hashfunction, provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            return false;
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            return false;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            byte[] buffer = new byte[8192];
            int length = 0;
            while ((length = fis.read(buffer)) != -1) {
                this.md.update(buffer, 0, length);
            }
            this.hash_raw = this.md.digest();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        BASE64Encoder enc = new BASE64Encoder();
        String base64 = enc.encode(this.hash_raw);
        System.out.println(base64);
        try {
            FileOutputStream fout = new FileOutputStream(filename + "." + hashfunction);
            DataOutputStream dout = new DataOutputStream(fout);
            dout.writeBytes(base64);
            dout.close();
            ret = true;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ret;
    }
}

