/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.examples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEs {
    private String algorithm = null;
    private String filename = null;
    private Key secretKey = null;
    private final byte[] salt = new byte[]{32, 33, 16, 85, -125, 1, 1, -111};
    private final int iterations;

    public boolean run(int mode, String filename) {
        boolean ret = false;
        PBEParameterSpec aps = new PBEParameterSpec(this.salt, 20);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.algorithm);
            cipher.init(mode, this.secretKey, aps);
            ret = true;
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (NoSuchPaddingException nspe) {
            nspe.printStackTrace();
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException iape) {
            iape.printStackTrace();
        }
        if (!ret) {
            return ret;
        }
        ret = false;
        CipherOutputStream cOutStream = null;
        CipherInputStream cInpStream = null;
        FileInputStream fInput = null;
        FileOutputStream fOutput = null;
        try {
            if (mode == 1) {
                fInput = new FileInputStream(filename);
                fOutput = new FileOutputStream(filename + ".PBEencrypted." + this.algorithm);
                cOutStream = new CipherOutputStream(fOutput, cipher);
                byte[] buffer = new byte[8192];
                int length = 0;
                while ((length = fInput.read(buffer)) != -1) {
                    cOutStream.write(buffer, 0, length);
                }
                fInput.close();
                cOutStream.close();
                ret = true;
            } else {
                fInput = new FileInputStream(filename + ".PBEencrypted." + this.algorithm);
                cInpStream = new CipherInputStream(fInput, cipher);
                fOutput = new FileOutputStream(filename + ".PBEdecrypted." + this.algorithm);
                byte[] buffer = new byte[8192];
                int length = 0;
                while ((length = cInpStream.read(buffer)) != -1) {
                    fOutput.write(buffer, 0, length);
                }
                cInpStream.close();
                fOutput.close();
                ret = true;
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return ret;
    }

    public PBEs(String algorithm, String passphrase) {
        this.iterations = 20;
        this.algorithm = algorithm;
        char[] pw = new char[passphrase.length()];
        passphrase.getChars(0, passphrase.length(), pw, 0);
        PBEKeySpec ks = new PBEKeySpec(pw);
        SecretKeyFactory skf = null;
        try {
            skf = SecretKeyFactory.getInstance(algorithm);
            this.secretKey = skf.generateSecret(ks);
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (InvalidKeySpecException ikse) {
            ikse.printStackTrace();
        }
    }
}

