/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnException;
import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;

public final class AsnBitString
extends AsnObject {
    private final byte[] val;

    public String toString(String prefix) {
        return "BIT_STRING";
    }

    public byte[] toByteArray() {
        return (byte[])this.val.clone();
    }

    protected void encodePayload(AsnOutputStream os) throws IOException {
        os.writeByte((byte)0);
        os.writeBytes(this.val);
    }

    protected int getEncodedLengthOfPayload(AsnOutputStream os) {
        return this.val.length + 1;
    }

    AsnBitString(AsnInputStream is) throws AsnException, IOException {
        super((byte)3);
        int len = is.readLength() - 1;
        if (len < 0) {
            throw new AsnException("Negative length.");
        }
        byte unused = is.readByte();
        if (unused != 0) {
            throw new AsnException("Length not a multiple of 8.");
        }
        this.val = is.readBytes(len);
    }

    public AsnBitString(byte[] value) {
        super((byte)3);
        this.val = (byte[])value.clone();
    }
}

