/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.Mode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

class ModeCFB
extends Mode {
    private final byte[] keyStreamBuf;
    private int keyStreamPtr;
    private final byte[] shiftReg;
    private int shiftRegPtr;
    protected long byteCount;
    private int feedbackSize;
    private boolean decrypt;
    private byte[] iVec = null;

    private void shiftInByte(byte b) {
        this.shiftReg[this.shiftRegPtr++ % this.CIPHER_BLOCK_SIZE] = b;
        ++this.byteCount;
        if (this.needCrank()) {
            this.crank();
        }
    }

    private void crank() {
        int i = 0;
        while (i < this.CIPHER_BLOCK_SIZE) {
            this.keyStreamBuf[i] = this.shiftReg[this.shiftRegPtr++ % this.CIPHER_BLOCK_SIZE];
            ++i;
        }
        this.cipher.coreCrypt(this.keyStreamBuf, 0, this.keyStreamBuf, 0);
        this.keyStreamPtr = 0;
    }

    protected boolean needCrank() {
        return this.byteCount % (long)this.feedbackSize == 0L;
    }

    final int coreGetOutputSize(int inputLen) {
        return inputLen;
    }

    void coreInit(boolean decrypt, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.coreInit(key, false);
        this.decrypt = decrypt;
        IvParameterSpec iv = (IvParameterSpec)params;
        this.iVec = iv.getIV();
        int iVecLen = this.iVec.length;
        if (iVecLen != this.CIPHER_BLOCK_SIZE) {
            throw new InvalidAlgorithmParameterException("Invalid IV specified, incorrect length.");
        }
        this.byteCount = 0L;
        System.arraycopy(this.iVec, 0, this.shiftReg, 0, iVecLen);
        this.crank();
    }

    int coreUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int todo = inputLen;
        while (todo-- > 0) {
            byte kb = this.keyStreamBuf[this.keyStreamPtr++];
            byte ib = input[inputOffset++];
            byte ob = (byte)(ib ^ kb);
            this.shiftInByte(this.decrypt ? ib : ob);
            output[outputOffset++] = ob;
        }
        return inputLen;
    }

    final byte[] coreGetIV() {
        return this.iVec;
    }

    final AlgorithmParameterSpec coreGetParamSpec() {
        if (this.iVec == null) {
            return new IvParameterSpec(this.generateIV());
        }
        return new IvParameterSpec(this.iVec);
    }

    final boolean needsPadding() {
        return false;
    }

    ModeCFB(BlockCipher cipher) {
        super(cipher);
        this.keyStreamBuf = new byte[this.CIPHER_BLOCK_SIZE];
        this.shiftReg = new byte[this.CIPHER_BLOCK_SIZE];
        this.feedbackSize = this.CIPHER_BLOCK_SIZE;
    }

    ModeCFB(BlockCipher cipher, int feedbackSize) throws NoSuchAlgorithmException {
        super(cipher);
        if (feedbackSize == 0 || feedbackSize % 8 != 0) {
            throw new NoSuchAlgorithmException("Feedback size is 0 or not a multiple of 8 bits.");
        }
        if ((feedbackSize /= 8) < 1 || feedbackSize > this.CIPHER_BLOCK_SIZE) {
            throw new NoSuchAlgorithmException("Feedback size <1 or >CIPHER_BLOCK_SIZE");
        }
        this.keyStreamBuf = new byte[this.CIPHER_BLOCK_SIZE];
        this.shiftReg = new byte[this.CIPHER_BLOCK_SIZE];
        this.feedbackSize = feedbackSize;
    }
}

