/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;

final class DSAPrivateKeyCryptix
implements DSAPrivateKey {
    private final BigInteger x;
    private final DSAParams params;

    public BigInteger getX() {
        return this.x;
    }

    public DSAParams getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "Cryptix";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MPIOutputStream mos = new MPIOutputStream((OutputStream)baos);
            mos.write(this.params.getP());
            mos.write(this.params.getQ());
            mos.write(this.params.getG());
            mos.write(this.x);
            mos.flush();
            mos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
    }

    DSAPrivateKeyCryptix(BigInteger x, DSAParams params) {
        this.x = x;
        this.params = params;
    }
}

