/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.random;

import cryptix.jce.provider.random.StatisticalTests;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandomSpi;

public final class DevRandom
extends SecureRandomSpi {
    private static final String RANDOM_DEV_NAME = "/dev/urandom";
    private static final File RANDOM_DEV = new File("/dev/urandom");
    private static FileInputStream randomStream = null;

    private static void getRandomBytes(byte[] bytes) throws IOException {
        int offset = 0;
        int todo = bytes.length;
        while (todo > 0) {
            int count;
            FileInputStream fileInputStream = randomStream;
            synchronized (fileInputStream) {
                count = randomStream.read(bytes, offset, todo);
                if (count == -1) {
                    throw new IOException("EOF");
                }
            }
            offset += count;
            todo -= count;
        }
    }

    protected void engineSetSeed(byte[] seed) {
    }

    protected void engineNextBytes(byte[] bytes) {
        try {
            DevRandom.getRandomBytes(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read from randomness device: " + e);
        }
    }

    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] seed = new byte[numBytes];
        this.engineNextBytes(seed);
        return seed;
    }

    public static boolean isAvailable() {
        return randomStream != null;
    }

    public DevRandom() {
        if (randomStream == null) {
            throw new InternalError("randomStream == null");
        }
    }

    static {
        try {
            randomStream = new FileInputStream(RANDOM_DEV);
            byte[] test_bytes = new byte[2500];
            DevRandom.getRandomBytes(test_bytes);
            if (!StatisticalTests.looksRandom(test_bytes)) {
                System.out.println("CryptixRandom Provider:Output of /dev/urandom doesn't look random, this may indicate a serious security problem!");
                randomStream.close();
                randomStream = null;
            }
        }
        catch (IOException e) {
            randomStream = null;
        }
    }
}

