//$Id: NTUtil.java 12:26:33
/*
 * Created on 2005/11/11
 *
 * Application Manager 6.0
 */
package HTTPClient;
import java.security.*;
import java.security.spec.*;

import javax.crypto.*;
import javax.crypto.spec.*;

import java.io.*;
/**
 * @author Yogendrababu
 *
 * TODO
 *
 */
public class NTUtil {
    private static final byte[] ARRAY = new byte[] {0x4B, 0x47, 0x53, 0x21, 0x40, 0x23, 0x24, 0x25};

    private static Key findDESKey(byte[] keyData, int offset) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] desKeyData = new byte[8];
        int[] k = new int[7];

        for(int i = 0; i < 7; i++)
	{
          k[i] = convertUnsignedByteToInt(keyData[offset + i]);
	}

        desKeyData[0] = (byte)(k[0] >>> 1);
        desKeyData[1] = (byte)(((k[0] & 0x01) << 6) | (k[1] >>> 2));
        desKeyData[2] = (byte)(((k[1] & 0x03) << 5) | (k[2] >>> 3));
        desKeyData[3] = (byte)(((k[2] & 0x07) << 4) | (k[3] >>> 4));
        desKeyData[4] = (byte)(((k[3] & 0x0F) << 3) | (k[4] >>> 5));
        desKeyData[5] = (byte)(((k[4] & 0x1F) << 2) | (k[5] >>> 6));
        desKeyData[6] = (byte)(((k[5] & 0x3F) << 1) | (k[6] >>> 7));
        desKeyData[7] = (byte)(k[6] & 0x7F);

        for(int i=0; i<8; i++)
	{
          desKeyData[i] = (byte)(convertUnsignedByteToInt(desKeyData[i]) << 1);
	}

        KeySpec desKeySpec = new DESKeySpec(desKeyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
        return secretKey;
      }
    private static int convertUnsignedByteToInt(byte b) {
        return (int)b & 0xFF;
      }
    public static byte[] getLanManagerPassword(String password) throws IllegalArgumentException, NoSuchPaddingException, NoSuchAlgorithmException {
        if(password == null)
	{
          throw new IllegalArgumentException("password : null value not allowed");
	}
        try {
          //Gets the first 14-bytes of the ASCII upper cased password
          int len = password.length();
          if(len > 14)
	  {
            len = 14;
	  }
          Cipher c = Cipher.getInstance("DES/ECB/NoPadding");

          byte[] lm_pw = new byte[14];
          byte[] bytes = password.toUpperCase().getBytes();
          int i;
          for(i = 0; i < len; i++)
	  {
            lm_pw[i] = bytes[i];
	  }
          for(; i < 14; i++)
	  {
            lm_pw[i] = 0;
	  }

          byte[] lm_hpw = new byte[16];
          //Builds a first DES key with its first 7 bytes
          Key k = findDESKey(lm_pw, 0);
          c.init(Cipher.ENCRYPT_MODE, k);
          //Hashes the MAGIC number with this key into the first 8 bytes of the result
          c.doFinal(ARRAY, 0, 8, lm_hpw, 0);

          //Repeats the work with the last 7 bytes to gets the last 8 bytes of the result
          k = findDESKey(lm_pw, 7);
          c.init(Cipher.ENCRYPT_MODE, k);
          c.doFinal(ARRAY, 0, 8, lm_hpw, 8);

          return lm_hpw;
        } catch(InvalidKeySpecException ex) {
          return null;
        } catch(InvalidKeyException ex) {
          return null;
        } catch(BadPaddingException ex) {
          return null;
        } catch(IllegalBlockSizeException ex) {
          return null;
        } catch(ShortBufferException ex) {
          return null;
        }
      }

    public static byte[] getNonce(byte[] msg) throws IllegalArgumentException {
        if(msg.length < 32)
	{
          throw new IllegalArgumentException("msg : illegal size");
	}
        byte[] nonce = new byte[8];
        System.arraycopy(msg, 24, nonce, 0, 8);
        return nonce;
      }
    public static byte[] getNTHashedPassword(String password) throws IllegalArgumentException, NoSuchAlgorithmException {
        if(password == null)
	{
          throw new IllegalArgumentException("password : null value not allowed");
	}
        //Gets the first 14-bytes of the UNICODE password
        int len = password.length();
        if(len > 14)
	{
          len = 14;
	}
        byte[] nt_pw = new byte[2 * len];
        for(int i = 0; i < len; i++) {
            char ch = password.charAt(i);
            nt_pw[2 * i] = (byte)ch;
            nt_pw[2 * i + 1] =(byte)((ch >>> 8) & 0xFF);
        }

        //Return its MD4 digest as the hashed version
        MessageDigest md = MessageDigest.getInstance("MD4");
        return md.digest(nt_pw);
      }


      public static byte[] buildResponse(String host, String user, String userDomain, byte[] lmPassword, byte[] ntPassword, byte[] nonce) throws IllegalArgumentException, IOException, NoSuchAlgorithmException, NoSuchPaddingException {
          if(host == null)
	  {
            throw new IllegalArgumentException("host : null value not allowed");
	  }
          if(user == null)
	  {
            throw new IllegalArgumentException("user : null value not allowed");
	  }
          if(userDomain == null){
            throw new IllegalArgumentException("userDomain : null value not allowed");
	  }
          if(lmPassword == null){
            throw new IllegalArgumentException("lmPassword : null value not allowed");
	  }
          if(ntPassword == null){
            throw new IllegalArgumentException("ntPassword : null value not allowed");
	  }
          if(nonce == null){
            throw new IllegalArgumentException("nonce : null value not allowed");
	  }
          if(lmPassword.length != 16){
            throw new IllegalArgumentException("lmPassword : illegal size");
	  }
          if(ntPassword.length != 16){
            throw new IllegalArgumentException("ntPassword : illegal size");
	  }
          if(nonce.length != 8){
            throw new IllegalArgumentException("nonce : illegal size");
	  }

          byte[] lmResponse = new byte[24];
          byte[] ntResponse = new byte[24];

          buildNTLMResponse(lmPassword, ntPassword, nonce, lmResponse, ntResponse);

          userDomain = userDomain.toUpperCase();
          host = host.toUpperCase();
          short lmRespLen = (short)0x18;
          short ntRespLen = (short)0x18;
          short domainLen = (short)(2 * userDomain.length());
          short hostLen = (short)(2 * host.length());
          short userLen = (short)(2 * user.length());
          short domainOff = (short)0x40;
          short userOff = (short)(domainOff + domainLen);
          short hostOff = (short)(userOff + userLen);
          short lmRespOff = (short)(hostOff + hostLen);
          short ntRespOff = (short)(lmRespOff + lmRespLen);
          short msgLen = (short)(ntRespOff + ntRespLen);
          ByteArrayOutputStream os = null;
          DataOutputStream dataOut = null;
	  try
	  {
	  os = new ByteArrayOutputStream(1024);
	  dataOut = new DataOutputStream(os);
          dataOut.writeBytes("NTLMSSP\0");
          dataOut.writeByte(0x03);
          dataOut.writeByte(0x00);
          dataOut.writeByte(0x00);
          dataOut.writeByte(0x00);
          dataOut.writeShort(switchBytes(lmRespLen));
          dataOut.writeShort(switchBytes(lmRespLen));
          dataOut.writeShort(switchBytes(lmRespOff));
          dataOut.writeShort(0x0000);
          dataOut.writeShort(switchBytes(ntRespLen));
          dataOut.writeShort(switchBytes(ntRespLen));
          dataOut.writeShort(switchBytes(ntRespOff));
          dataOut.writeShort(0x0000);
          dataOut.writeShort(switchBytes(domainLen));
          dataOut.writeShort(switchBytes(domainLen));
          dataOut.writeShort(switchBytes(domainOff));
          dataOut.writeShort(0x0000);
          dataOut.writeShort(switchBytes(userLen));
          dataOut.writeShort(switchBytes(userLen));
          dataOut.writeShort(switchBytes(userOff));
          dataOut.writeShort(0x0000);
          dataOut.writeShort(switchBytes(hostLen));
          dataOut.writeShort(switchBytes(hostLen));
          dataOut.writeShort(switchBytes(hostOff));
          dataOut.writeShort(0x0000);
          dataOut.writeInt(0x00000000);
          dataOut.writeShort(switchBytes(msgLen));
          dataOut.writeShort(0x0000);
          dataOut.writeShort(0x0000);  //    dataOut.writeShort(swapBytes((short)0x8201));
          dataOut.writeShort(0x0000);

          for(int i = 0; i < userDomain.length(); i++)
	  {
            dataOut.writeShort(switchBytes((short)userDomain.charAt(i)));
	  }
          for(int i = 0; i < user.length(); i++)
	  {
            dataOut.writeShort(switchBytes((short)user.charAt(i)));
	  }
          for(int i = 0; i < host.length(); i++)
	  {
            dataOut.writeShort(switchBytes((short)host.charAt(i)));
	  }
          dataOut.write(lmResponse);
          dataOut.write(ntResponse);
          dataOut.flush();
	  }
	  finally
	  {
		  os.close();
		  dataOut.close();
	  }
          return os.toByteArray();
        }
      private static short switchBytes(short s) {
          return (short)(((s << 8) & 0xFF00) | ((s >>> 8) & 0x00FF));
        }

      private static void buildNTLMResponse(byte[] lmPassword, byte[] ntPassword, byte[] nonce, byte[] lmResponse, byte[] ntResponse) throws IllegalArgumentException, NoSuchPaddingException, NoSuchAlgorithmException {
          if(lmPassword.length != 16)
	  {
            throw new IllegalArgumentException("lmPassword : illegal size");
	  }
          if(ntPassword.length != 16)
	  {
            throw new IllegalArgumentException("ntPassword : illegal size");
	  }
          if(nonce.length != 8)
	  {
            throw new IllegalArgumentException("nonce : illegal size");
	  }
          if(lmResponse.length != 24){
            throw new IllegalArgumentException("lmResponse : illegal size");
	  }
          if(ntResponse.length != 24){
            throw new IllegalArgumentException("ntResponse : illegal size");
	  }
          try {
            //Puts the hashed passwords into 21-bytes arrays with trailing 0s
            byte[] lmHPw = new byte[21];
            byte[] ntHPw = new byte[21];
            System.arraycopy(lmPassword, 0, lmHPw, 0, 16);
            System.arraycopy(ntPassword, 0, ntHPw, 0, 16);
            for(int i = 16; i < 21; i++) {
              lmHPw[i] = 0;
              ntHPw[i] = 0;
            }
            //Encrypts the nonce with the padded hashed passwords to compute the responses
            System.arraycopy(encrypt(lmHPw, nonce), 0, lmResponse, 0, 24);
            System.arraycopy(encrypt(ntHPw, nonce), 0, ntResponse, 0, 24);
          } catch(ShortBufferException ex) {
          } catch(IllegalBlockSizeException ex) {
          } catch(BadPaddingException ex) {
          } catch(InvalidKeySpecException ex) {
          } catch(InvalidKeyException ex) {
          }
        }
      private static byte[] encrypt(byte[] keys, byte[] plaintext) throws InvalidKeyException, NoSuchAlgorithmException, javax.crypto.NoSuchPaddingException, InvalidKeySpecException, BadPaddingException, IllegalBlockSizeException, ShortBufferException {
          byte[] ciphertext = new byte[24];
          Cipher c = Cipher.getInstance("DES/ECB/NoPadding");
          Key k = findDESKey(keys, 0);
          c.init(Cipher.ENCRYPT_MODE, k);
          c.doFinal(plaintext, 0, 8, ciphertext, 0);
          k = findDESKey(keys, 7);
          c.init(Cipher.ENCRYPT_MODE, k);
          c.doFinal(plaintext, 0, 8, ciphertext, 8);
          k = findDESKey(keys, 14);
          c.init(Cipher.ENCRYPT_MODE, k);
          c.doFinal(plaintext, 0, 8, ciphertext, 16);
          return ciphertext;
        }
      public static byte[] buildRequest(String host, String hostDomain) throws IOException {
          hostDomain = hostDomain.toUpperCase();
          host = host.toUpperCase();
          short domainLen = (short)hostDomain.length();
          short hostLen = (short)host.length();
          short hostOff = 0x20;
          short domainOff = (short)(hostOff + hostLen);
          ByteArrayOutputStream os = null;
          DataOutputStream dataOut = null;
	  try
	  {
	  os = new ByteArrayOutputStream(1024);
	  dataOut = new DataOutputStream(os);
          dataOut.writeBytes("NTLMSSP\0");
          dataOut.writeByte(0x01);
          dataOut.writeByte(0x00);
          dataOut.writeByte(0x00);
          dataOut.writeByte(0x00);
          dataOut.writeShort(switchBytes((short)0xb203));
          dataOut.writeShort(0x0000);
          dataOut.writeShort(switchBytes(domainLen));
          dataOut.writeShort(switchBytes(domainLen));
          dataOut.writeShort(switchBytes(domainOff));
          dataOut.writeShort(0x0000);
          dataOut.writeShort(switchBytes(hostLen));
          dataOut.writeShort(switchBytes(hostLen));
          dataOut.writeShort(switchBytes(hostOff));
          dataOut.writeShort(0x0000);
          dataOut.write(host.getBytes());
          dataOut.write(hostDomain.getBytes());
          dataOut.flush();
	  }
	  finally
	  {
		  os.close();
		  dataOut.close();
	  }
          return os.toByteArray();
        }
}
