/*$Id: DCAuthorizationPrompter.java,v 1.2 2011/09/03 07:24:51 mathankarthik.r Exp $*/
package com.adventnet.sym.server.downloadmgr;

import HTTPClient.AuthorizationInfo;
import HTTPClient.NVPair;
import HTTPClient.AuthorizationPrompter;

/**
 * This class can be used for providing the authentication details when requested by NTLM Authentication.
 * @author rajeshr
 */

public class DCAuthorizationPrompter implements AuthorizationPrompter
{

	private String proxyUser = null;
	private String proxyPass = null;

/**
 * This is the constructor with userName and password as args. The proxy username and password
 * need to be passed.
 * @param userName
 * @param password
 */
	public DCAuthorizationPrompter(String userName, String password)
	{
		this.proxyUser = userName;
		this.proxyPass = password;
	}
/**
 * Default constructor.
 */
	public DCAuthorizationPrompter()
	{
	}

        /**
         * To enable the support for NTLM Authentication, the proxy username and password should
         * be returned to the calling method as NVPair.
         * @param challenge
         * @param forProxy
         * @return NVPair
         * @throws Exception
         */
	public NVPair getUsernamePassword(AuthorizationInfo challenge, boolean forProxy) throws Exception
	{

		if ( proxyUser != null && proxyPass != null )
		{
			return new NVPair(proxyUser,proxyPass);
		}
		return null;
	}
}

