//$Id$
/*
 * Created on 2005/10/17
 *
 * Application Manager 6.0
 */
package HTTPClient;
import java.util.StringTokenizer;
import java.io.IOException;

/**
 * @author Yogendrababu
 * This class is meant for supporting Window Integrated Auth enabled URL Monitoring  
 *  * <pre>
 *     HTTPClient.AuthorizationHandler ntlm = new NTLMAuthorizationHandler(host, hostDomain, user,
 *       userDomain, password);
 *     HTTPClient.AuthorizationInfo.setAuthHandler(ntlm);
 * </pre>
 *
 */
public class NTLMAuthorizationHandler implements AuthorizationHandler {

    
    private DefaultAuthHandler defaultAuthHandler = null;

    private static final String NTLM_TAG = "NTLM";

    private static final String PROXY_AUTHENTICATE_HEADER = "Proxy-Authenticate";

    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";

    private static AuthorizationPrompter prompter = null;

    private static boolean prompterSet = false;

    private String host = null;
    private String hostDomain = null;
    /**
     * 
     */
    public NTLMAuthorizationHandler() {
        super();
        defaultAuthHandler = new DefaultAuthHandler();
        host = System.getProperty("HTTPClient.host");
        hostDomain = System.getProperty("HTTPClient.hostDomain");
    }

    /* (non-Javadoc)
     * @see HTTPClient.AuthorizationHandler#getAuthorization(HTTPClient.AuthorizationInfo, HTTPClient.RoRequest, HTTPClient.RoResponse)
     */
    public AuthorizationInfo getAuthorization(AuthorizationInfo arg0,
            RoRequest arg1, RoResponse arg2) throws AuthSchemeNotImplException,
            IOException {
        if(arg0.getScheme().equalsIgnoreCase("NTLM") || arg0.getScheme().equalsIgnoreCase("Negotiate"))
    	{
            try {
        		byte[] nonce = null;
              String msg;
            //  System.out.println("Hashcode in getAuthorization "+parm3.hashCode());
              String ntlmchallenge = arg2.getHeader("nonce");
              if(ntlmchallenge!=null)
              {
        		  try
        		  {
        		  	nonce = NTUtil.getNonce(Codecs.base64Decode(ntlmchallenge.getBytes()));
			  	  }
			  	  catch(java.lang.ArrayIndexOutOfBoundsException exp)
			  	  {
					  nonce = NTUtil.getNonce(ntlmchallenge.getBytes());
				  }
        	  }
        	  else
        	  {
        		  nonce = null;
        	  }

              if(nonce != null)
              {
              	NVPair answer;
            	synchronized (getClass())
            	{
            	    if (!arg1.allowUI()  ||  prompterSet  &&  prompter == null)
		    {
            		return null;
		    }

            	    if (prompter == null)
		    {
            		setDefaultPrompter();
		    }

            	    answer = prompter.getUsernamePassword(arg0,
            						  arg2.getStatusCode() == 407);
            	}

            	if (answer == null)
		{
            	    return null;
		}
            	String userDomain = "";
            	String username = answer.getName();
            	String password = answer.getValue();
            	StringTokenizer tokens = new StringTokenizer(username,"\\");
            	if(tokens.hasMoreElements())
            	{
            	    userDomain = tokens.nextToken();
            	}
            	if(tokens.hasMoreElements())
            	{
            	    username= tokens.nextToken();
            	}
            	// TODO replace yogendrav and AdventNet with hostname and domainname of the client(The machine in which AppManager is running)

                msg = new String(Codecs.base64Encode(NTUtil.buildResponse(host, username, userDomain, NTUtil.getLanManagerPassword(password), NTUtil.getNTHashedPassword(password), nonce)));

            	
               

                               
        	}
              else
              {
                msg = new String(Codecs.base64Encode(NTUtil.buildRequest(host, hostDomain))); 
                //System.out.println("Sending domain info");
        	}
              return new AuthorizationInfo(arg0.getHost(), arg0.getPort(), NTLM_TAG, "", msg);
            } catch(Exception ex) {
              ex.printStackTrace();
              throw new IOException();
            }

    	}
        return defaultAuthHandler.getAuthorization(arg0,arg1,arg2);
    }

    /* (non-Javadoc)
     * @see HTTPClient.AuthorizationHandler#fixupAuthInfo(HTTPClient.AuthorizationInfo, HTTPClient.RoRequest, HTTPClient.AuthorizationInfo, HTTPClient.RoResponse)
     */
    public AuthorizationInfo fixupAuthInfo(AuthorizationInfo arg0,
            RoRequest arg1, AuthorizationInfo arg2, RoResponse arg3)
            throws AuthSchemeNotImplException, IOException {
        if (arg0.getScheme().equalsIgnoreCase("NTLM"))
	{
        	    return arg0;
	}
        return defaultAuthHandler.fixupAuthInfo(arg0,arg1,arg2,arg3);
    }

    /* (non-Javadoc)
     * @see HTTPClient.AuthorizationHandler#handleAuthHeaders(HTTPClient.Response, HTTPClient.RoRequest, HTTPClient.AuthorizationInfo, HTTPClient.AuthorizationInfo)
     */
    public void handleAuthHeaders(Response arg0, RoRequest arg1,
            AuthorizationInfo arg2, AuthorizationInfo arg3) throws IOException {
        
        byte[] nonce = null;
        String ntlmchallenge = null;
	try {
		String challenge = arg0.getHeader(PROXY_AUTHENTICATE_HEADER);
		if((challenge != null) && challenge.startsWith(NTLM_TAG) && challenge.length() > 7)
		{
			ntlmchallenge = challenge.substring(challenge.indexOf(' ') + 1).trim();
		}
		else {
			challenge = arg0.getHeader(WWW_AUTHENTICATE_HEADER);
			if((challenge != null) && challenge.startsWith(NTLM_TAG) && challenge.length() > 7)
			{
				ntlmchallenge = challenge.substring(challenge.indexOf(' ') + 1).trim();
			}
		}
	} catch(Exception ex) {
		ex.printStackTrace();
	}
        if(ntlmchallenge!=null)
        {
    		arg0.setHeader("nonce",ntlmchallenge);
    	}
        //System.out.println("nounce is "+nonce+"---- response "+arg0.hashCode());        
        defaultAuthHandler.handleAuthHeaders(arg0,arg1,arg2,arg3);    

    }

    /* (non-Javadoc)
     * @see HTTPClient.AuthorizationHandler#handleAuthTrailers(HTTPClient.Response, HTTPClient.RoRequest, HTTPClient.AuthorizationInfo, HTTPClient.AuthorizationInfo)
     */
    public void handleAuthTrailers(Response arg0, RoRequest arg1,
            AuthorizationInfo arg2, AuthorizationInfo arg3) throws IOException {
        if(arg2.getScheme().equalsIgnoreCase("NTLM"))
        {
            // do nothing for NTLM
            return;
        }
        defaultAuthHandler.handleAuthTrailers(arg0,arg1,arg2,arg3);
    }

    public static void main(String[] args) {
    }
    /**
     * Set a new username/password prompter.
     *
     * @param prompt the AuthorizationPrompter to use whenever a username
     *               and password are needed; if null, no querying will be
     *               done
     * @return the previous prompter
     */
    public static synchronized AuthorizationPrompter setAuthorizationPrompter(
					    AuthorizationPrompter prompt)
    {
	AuthorizationPrompter prev = prompter;
	prompter    = prompt;
	prompterSet = true;
	return prev;
    }

    /**
     * Set the default authorization prompter. It first tries to figure out
     * if the AWT is running, and if it is then the GUI popup prompter is used;
     * otherwise the command line prompter is used.
     */
    private static void setDefaultPrompter()
    {
	// if the AWT is running use the popup box; else use the
	// the command line prompter.
	if (!SimpleAuthPrompt.canUseCLPrompt()  ||  isAWTRunning())
	{
	    prompter = new SimpleAuthPopup();
	}
	else
	{
	    prompter = new SimpleAuthPrompt();
	}
    }
    /**
     * Try and figure out if the AWT is running. This is done by searching all
     * threads and looking for one whose name starts with "AWT-". 
     */
    private static final boolean isAWTRunning() {
	// find top-level thread group
	ThreadGroup root = Thread.currentThread().getThreadGroup();
	while (root.getParent() != null)
	{
	    root = root.getParent();
	}

	// search all threads
	Thread[] t_list = new Thread[root.activeCount() + 5];
	int t_num = root.enumerate(t_list);
	for (int idx=0; idx<t_num; idx++)
	{
	    if (t_list[idx].getName().startsWith("AWT-"))
	    {
		return true;
	    }
	}

	return false;
    }


}
