/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.protocol.xml.server;

import com.sun.xml.internal.ws.encoding.xml.XMLMessage;
import com.sun.xml.internal.ws.handler.HandlerChainCaller;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.handler.XMLHandlerContext;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.pept.presentation.TargetFinder;
import com.sun.xml.internal.ws.pept.presentation.Tie;
import com.sun.xml.internal.ws.pept.protocol.MessageDispatcher;
import com.sun.xml.internal.ws.server.AppMsgContextImpl;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.server.RuntimeEndpointInfo;
import com.sun.xml.internal.ws.server.provider.ProviderModel;
import com.sun.xml.internal.ws.server.provider.ProviderPeptTie;
import com.sun.xml.internal.ws.spi.runtime.Binding;
import com.sun.xml.internal.ws.spi.runtime.Invoker;
import com.sun.xml.internal.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import com.sun.xml.internal.ws.spi.runtime.WebServiceContext;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.XMLConnectionUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.handler.MessageContext;

public abstract class XMLMessageDispatcher
implements MessageDispatcher {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.xmlmd");

    public void send(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageInfo messageInfo) {
        boolean bl;
        block16: {
            XMLMessage xMLMessage = null;
            try {
                xMLMessage = this.getXMLMessage(messageInfo);
            }
            catch (Exception exception) {
                this.sendResponseError(messageInfo, exception);
                return;
            }
            bl = false;
            try {
                if (xMLMessage.acceptFastInfoset()) {
                    messageInfo.setMetaData("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
                }
                XMLHandlerContext xMLHandlerContext = new XMLHandlerContext(messageInfo, null, xMLMessage);
                this.updateHandlerContext(messageInfo, xMLHandlerContext);
                SystemHandlerDelegate systemHandlerDelegate = this.getSystemHandlerDelegate(messageInfo);
                XmlInvoker xmlInvoker = new XmlInvoker(messageInfo, xMLMessage, xMLHandlerContext, systemHandlerDelegate);
                try {
                    if (systemHandlerDelegate == null) {
                        xmlInvoker.invoke();
                    } else {
                        xMLHandlerContext.setInvoker(xmlInvoker);
                        if (systemHandlerDelegate.processRequest(xMLHandlerContext.getSHDXMLMessageContext())) {
                            xmlInvoker.invoke();
                            xMLHandlerContext.getMessageContext().put("javax.xml.ws.handler.message.outbound", Boolean.TRUE);
                            systemHandlerDelegate.processResponse(xMLHandlerContext.getSHDXMLMessageContext());
                        }
                    }
                }
                finally {
                    bl = xmlInvoker.isSent();
                }
                if (!XMLMessageDispatcher.isOneway(messageInfo)) {
                    bl = true;
                    this.sendResponse(messageInfo, xMLHandlerContext);
                } else if (!bl) {
                    bl = true;
                    this.sendResponseOneway(messageInfo);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.log(Level.SEVERE, exception.getMessage(), exception);
                if (bl) break block16;
                this.sendResponseError(messageInfo, exception);
            }
        }
        assert (bl);
    }

    protected abstract void toMessageInfo(MessageInfo var1, XMLHandlerContext var2);

    private XMLMessage getXMLMessage(MessageInfo messageInfo) {
        WSConnection wSConnection = messageInfo.getConnection();
        return XMLConnectionUtil.getXMLMessage(wSConnection, messageInfo);
    }

    private void invokeEndpoint(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) {
        TargetFinder targetFinder = messageInfo.getEPTFactory().getTargetFinder(messageInfo);
        Tie tie = targetFinder.findTarget(messageInfo);
        tie._invoke(messageInfo);
    }

    protected XMLMessage getResponse(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) {
        XMLMessage xMLMessage;
        int n;
        Object object;
        this.setResponseInContext(messageInfo, xMLHandlerContext);
        try {
            object = this.getCallerFromMessageInfo(messageInfo);
            if (object != null && ((HandlerChainCaller)object).hasHandlers()) {
                n = messageInfo.getResponseType();
                if (n || n == 2) {
                    this.callHandleFault((HandlerChainCaller)object, xMLHandlerContext);
                } else {
                    this.callHandlersOnResponse((HandlerChainCaller)object, xMLHandlerContext);
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            n = messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic" ? 1 : 0;
            xMLMessage = new XMLMessage(exception, n != 0);
            xMLHandlerContext.setXMLMessage(xMLMessage);
        }
        object = xMLHandlerContext.getMessageContext();
        Map map = (Map)object.get("javax.xml.ws.binding.attachments.outbound");
        if (map != null) {
            xMLMessage = xMLHandlerContext.getXMLMessage();
            Map map2 = xMLMessage.getAttachments();
            if (map2 != null) {
                map2.putAll(map);
            } else {
                map2 = map;
            }
            xMLMessage = new XMLMessage(xMLMessage.getSource(), map2, xMLMessage.isFastInfoset());
            xMLHandlerContext.setXMLMessage(xMLMessage);
        }
        return xMLHandlerContext.getXMLMessage();
    }

    protected abstract void setResponseInContext(MessageInfo var1, XMLHandlerContext var2);

    private void sendResponse(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) throws IOException {
        XMLMessage xMLMessage = xMLHandlerContext.getXMLMessage();
        MessageContext messageContext = xMLHandlerContext.getMessageContext();
        WSConnection wSConnection = messageInfo.getConnection();
        Integer n = MessageContextUtil.getHttpStatusCode(messageContext);
        int n2 = n == null ? xMLMessage.getStatus() : n.intValue();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        Map<String, List<String>> map = MessageContextUtil.getHttpResponseHeaders(messageContext);
        if (map != null) {
            hashMap.putAll(map);
        }
        MimeHeaders mimeHeaders = xMLMessage.getMimeHeaders();
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String string = mimeHeader.getName();
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(mimeHeader.getValue());
        }
        wSConnection.setStatus(n2);
        wSConnection.setHeaders(hashMap);
        xMLMessage.writeTo(wSConnection.getOutput());
        wSConnection.closeOutput();
    }

    protected void sendResponseOneway(MessageInfo messageInfo) {
        WSConnection wSConnection = messageInfo.getConnection();
        XMLConnectionUtil.sendResponseOneway(wSConnection);
    }

    private void sendResponseError(MessageInfo messageInfo, Exception exception) {
        logger.log(Level.SEVERE, exception.getMessage(), exception);
        WSConnection wSConnection = messageInfo.getConnection();
        XMLConnectionUtil.sendResponseError(wSConnection, messageInfo);
    }

    private boolean callHandlersOnRequest(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext, boolean bl) {
        boolean bl2 = false;
        HandlerChainCaller handlerChainCaller = this.getCallerFromMessageInfo(messageInfo);
        if (handlerChainCaller != null && handlerChainCaller.hasHandlers()) {
            bl2 = !handlerChainCaller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, xMLHandlerContext, bl);
        }
        return bl2;
    }

    private boolean hasHandlers(MessageInfo messageInfo) {
        HandlerChainCaller handlerChainCaller = this.getCallerFromMessageInfo(messageInfo);
        return handlerChainCaller != null && handlerChainCaller.hasHandlers();
    }

    private HandlerChainCaller getCallerFromMessageInfo(MessageInfo messageInfo) {
        HandlerChainCaller handlerChainCaller = MessageInfoUtil.getHandlerChainCaller(messageInfo);
        if (handlerChainCaller == null) {
            RuntimeContext runtimeContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
            Binding binding = runtimeContext.getRuntimeEndpointInfo().getBinding();
            handlerChainCaller = new HandlerChainCaller(binding.getHandlerChain());
            MessageInfoUtil.setHandlerChainCaller(messageInfo, handlerChainCaller);
        }
        return handlerChainCaller;
    }

    protected boolean callHandlersOnResponse(HandlerChainCaller handlerChainCaller, XMLHandlerContext xMLHandlerContext) {
        return handlerChainCaller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, xMLHandlerContext, false);
    }

    protected boolean callHandleFault(HandlerChainCaller handlerChainCaller, XMLHandlerContext xMLHandlerContext) {
        return false;
    }

    private void closeHandlers(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) {
        HandlerChainCaller handlerChainCaller = this.getCallerFromMessageInfo(messageInfo);
        if (handlerChainCaller != null && handlerChainCaller.hasHandlers()) {
            handlerChainCaller.forceCloseHandlersOnServer(xMLHandlerContext);
        }
    }

    private static boolean isFailure(MessageInfo messageInfo) {
        return messageInfo.getResponseType() == 2;
    }

    public static boolean isOneway(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 2;
    }

    protected void updateWebServiceContext(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) {
        RuntimeEndpointInfo runtimeEndpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        WebServiceContext webServiceContext = runtimeEndpointInfo.getWebServiceContext();
        if (webServiceContext != null) {
            AppMsgContextImpl appMsgContextImpl = new AppMsgContextImpl(xMLHandlerContext.getMessageContext());
            webServiceContext.setMessageContext(appMsgContextImpl);
        }
    }

    private void updateHandlerContext(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) {
        RuntimeEndpointInfo runtimeEndpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        WebServiceContext webServiceContext = runtimeEndpointInfo.getWebServiceContext();
        if (webServiceContext != null) {
            xMLHandlerContext.setMessageContext(webServiceContext.getMessageContext());
        }
    }

    private SystemHandlerDelegate getSystemHandlerDelegate(MessageInfo messageInfo) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo runtimeEndpointInfo = runtimeContext.getRuntimeEndpointInfo();
        return runtimeEndpointInfo.getBinding().getSystemHandlerDelegate();
    }

    private void setInboundAttachments(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) {
        XMLMessage xMLMessage;
        Map<String, DataHandler> map;
        if (this.hasHandlers(messageInfo) && (map = (xMLMessage = xMLHandlerContext.getXMLMessage()).getAttachments()) != null) {
            MessageContext messageContext = xMLHandlerContext.getMessageContext();
            messageContext.put("javax.xml.ws.binding.attachments.inbound", map);
            messageContext.setScope("javax.xml.ws.binding.attachments.inbound", MessageContext.Scope.APPLICATION);
            xMLMessage = new XMLMessage(xMLMessage.getSource(), xMLMessage.isFastInfoset());
            xMLHandlerContext.setXMLMessage(xMLMessage);
        }
    }

    private void processInboundAttachments(MessageInfo messageInfo, XMLHandlerContext xMLHandlerContext) {
        RuntimeContext runtimeContext;
        RuntimeEndpointInfo runtimeEndpointInfo;
        ProviderModel providerModel;
        boolean bl;
        if (this.hasHandlers(messageInfo) && !(bl = (providerModel = (runtimeEndpointInfo = (runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo)).getRuntimeEndpointInfo()).getProviderModel()).isSource())) {
            XMLMessage xMLMessage = xMLHandlerContext.getXMLMessage();
            MessageContext messageContext = xMLHandlerContext.getMessageContext();
            Map map = (Map)messageContext.get("javax.xml.ws.binding.attachments.inbound");
            xMLMessage = new XMLMessage(xMLMessage.getSource(), map, xMLMessage.isFastInfoset());
            xMLHandlerContext.setXMLMessage(xMLMessage);
        }
    }

    private class XmlInvoker
    implements Invoker {
        MessageInfo messageInfo;
        XMLMessage xmlMessage;
        XMLHandlerContext context;
        SystemHandlerDelegate shd;
        boolean sent;

        XmlInvoker(MessageInfo messageInfo, XMLMessage xMLMessage, XMLHandlerContext xMLHandlerContext, SystemHandlerDelegate systemHandlerDelegate) {
            this.messageInfo = messageInfo;
            this.xmlMessage = xMLMessage;
            this.context = xMLHandlerContext;
            this.shd = systemHandlerDelegate;
        }

        public void invoke() throws Exception {
            boolean bl = false;
            XMLMessageDispatcher.this.setInboundAttachments(this.messageInfo, this.context);
            bl = XMLMessageDispatcher.this.callHandlersOnRequest(this.messageInfo, this.context, true);
            if (!bl) {
                XMLMessageDispatcher.this.processInboundAttachments(this.messageInfo, this.context);
                XMLMessageDispatcher.this.toMessageInfo(this.messageInfo, this.context);
                if (!XMLMessageDispatcher.isFailure(this.messageInfo)) {
                    if (this.shd != null) {
                        this.shd.preInvokeEndpointHook(this.context.getSHDXMLMessageContext());
                    }
                    XMLMessageDispatcher.this.updateWebServiceContext(this.messageInfo, this.context);
                    XMLMessageDispatcher.this.invokeEndpoint(this.messageInfo, this.context);
                    if (!this.sent && XMLMessageDispatcher.isOneway(this.messageInfo)) {
                        this.sent = true;
                        XMLMessageDispatcher.this.sendResponseOneway(this.messageInfo);
                    }
                }
                if (XMLMessageDispatcher.isOneway(this.messageInfo)) {
                    if (XMLMessageDispatcher.isFailure(this.messageInfo)) {
                        // empty if block
                    }
                } else {
                    XMLMessageDispatcher.this.updateHandlerContext(this.messageInfo, this.context);
                    this.xmlMessage = XMLMessageDispatcher.this.getResponse(this.messageInfo, this.context);
                    this.context.setXMLMessage(this.xmlMessage);
                }
            }
        }

        public Method getMethod(QName qName) {
            return ProviderPeptTie.invoke_Method;
        }

        public boolean isSent() {
            return this.sent;
        }
    }
}

