/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.AlphaComposite;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.SurfaceManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.d3d.D3DBlitLoops;
import sun.java2d.d3d.D3DContext;
import sun.java2d.d3d.D3DDrawImage;
import sun.java2d.d3d.D3DMaskFill;
import sun.java2d.d3d.D3DRenderer;
import sun.java2d.d3d.D3DTextRenderer;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.windows.Win32OffScreenSurfaceData;
import sun.java2d.windows.Win32SurfaceData;
import sun.java2d.windows.WinVolatileSurfaceManager;
import sun.java2d.windows.WindowsFlags;

public class D3DSurfaceData
extends Win32OffScreenSurfaceData {
    public static final int D3D_ATTACHED_SURFACE = 32768;
    public static final int D3D_RENDER_TARGET = 65536;
    public static final int D3D_INVALID_SURFACE = 0;
    public static final int D3D_PLAIN_SURFACE = 65537;
    public static final int D3D_TEXTURE_SURFACE = 2;
    public static final int D3D_BACKBUFFER_SURFACE = 98305;
    public static final int D3D_RTT_SURFACE = 65538;
    public static final int PF_INVALID = 0;
    public static final int PF_INT_ARGB = 1;
    public static final int PF_INT_RGB = 2;
    public static final int PF_INT_RGBX = 3;
    public static final int PF_INT_BGR = 4;
    public static final int PF_USHORT_565_RGB = 5;
    public static final int PF_USHORT_555_RGB = 6;
    public static final int PF_USHORT_555_RGBX = 7;
    public static final int PF_INT_ARGB_PRE = 8;
    public static final int PF_USHORT_4444_ARGB = 9;
    public static final String DESC_INT_ARGB_D3D = "Integer ARGB D3D with translucency";
    public static final String DESC_USHORT_4444_ARGB_D3D = "UShort 4444 ARGB D3D with translucency";
    public static final String DESC_DEST_D3D = "D3D render target";
    public static final SurfaceType D3DSurface = SurfaceType.Any.deriveSubType("Direct3D Surface");
    public static final SurfaceType D3DTexture = D3DSurface.deriveSubType("Direct3D Texture");
    public static final SurfaceType IntRgbD3D = Win32SurfaceData.IntRgbDD.deriveSubType("D3D render target");
    public static final SurfaceType IntRgbxD3D = Win32SurfaceData.IntRgbxDD.deriveSubType("D3D render target");
    public static final SurfaceType Ushort565RgbD3D = Win32SurfaceData.Ushort565RgbDD.deriveSubType("D3D render target");
    public static final SurfaceType Ushort555RgbxD3D = Win32SurfaceData.Ushort555RgbxDD.deriveSubType("D3D render target");
    public static final SurfaceType Ushort555RgbD3D = Win32SurfaceData.Ushort555RgbDD.deriveSubType("D3D render target");
    public static final SurfaceType ThreeByteBgrD3D = Win32SurfaceData.ThreeByteBgrDD.deriveSubType("D3D render target");
    public static final SurfaceType IntArgbD3D = SurfaceType.IntArgb.deriveSubType("Integer ARGB D3D with translucency");
    public static final SurfaceType Ushort4444ArgbD3D = SurfaceType.Ushort4444Argb.deriveSubType("UShort 4444 ARGB D3D with translucency");
    public static final SurfaceType IntRgbD3D_RTT = IntRgbD3D.deriveSubType("D3D render target");
    public static final SurfaceType IntRgbxD3D_RTT = IntRgbxD3D.deriveSubType("D3D render target");
    public static final SurfaceType Ushort565RgbD3D_RTT = Ushort565RgbD3D.deriveSubType("D3D render target");
    public static final SurfaceType Ushort555RgbxD3D_RTT = Ushort555RgbxD3D.deriveSubType("D3D render target");
    public static final SurfaceType Ushort555RgbD3D_RTT = Ushort555RgbD3D.deriveSubType("D3D render target");
    public static final SurfaceType Ushort4444ArgbD3D_RTT = Ushort4444ArgbD3D.deriveSubType("D3D render target");
    public static final SurfaceType IntArgbD3D_RTT = IntArgbD3D.deriveSubType("D3D render target");
    public static final SurfaceType ThreeByteBgrD3D_RTT = ThreeByteBgrD3D.deriveSubType("D3D render target");
    protected int type;
    protected int pixelFormat;
    private D3DContext d3dContext;
    protected static D3DRenderer d3dPipe;
    protected static PixelToShapeConverter d3dTxPipe;
    protected static D3DTextRenderer d3dTextPipe;
    protected static D3DDrawImage d3dDrawImagePipe;

    private native void initOps(int var1, int var2);

    protected D3DSurfaceData(int n, int n2, int n3, SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n4) {
        super(surfaceType, colorModel);
        this.width = n;
        this.height = n2;
        this.type = n3;
        this.graphicsConfig = graphicsConfiguration;
        this.image = image;
        this.transparency = n4;
        this.solidloops = ((Win32GraphicsConfig)this.graphicsConfig).getSolidLoops(surfaceType);
        this.initOps(colorModel.getPixelSize(), n4);
    }

    private D3DSurfaceData(int n, int n2, int n3, SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n4, int n5) {
        this(n, n2, n3, surfaceType, colorModel, graphicsConfiguration, image, n4);
        this.pixelFormat = this.initSurface(n, n2, n5, null);
    }

    public static D3DSurfaceData createData(int n, int n2, int n3, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)graphicsConfiguration.getDevice();
        if (!win32GraphicsDevice.isD3DEnabledOnDevice()) {
            return null;
        }
        return new D3DSurfaceData(n, n2, n3, D3DSurfaceData.getSurfaceType(graphicsConfiguration, colorModel, n3), colorModel, graphicsConfiguration, image, colorModel.getTransparency(), win32GraphicsDevice.getScreen());
    }

    int getPixelFormat() {
        return this.pixelFormat;
    }

    static SurfaceType getSurfaceType(GraphicsConfiguration graphicsConfiguration, ColorModel colorModel, int n) {
        boolean bl;
        if (n == 2) {
            return D3DTexture;
        }
        int n2 = colorModel.getPixelSize();
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)graphicsConfiguration.getDevice();
        int n3 = colorModel.getTransparency();
        boolean bl2 = bl = (n & 0x10000) != 0 && (n & 0x18001) == 0 && win32GraphicsDevice.getD3DContext().isRTTSupported();
        if (n3 == 3 || n3 == 2) {
            if (n2 == 16) {
                return bl ? Ushort4444ArgbD3D_RTT : null;
            }
            return bl ? IntArgbD3D_RTT : null;
        }
        switch (n2) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        return bl ? IntRgbD3D_RTT : IntRgbD3D;
                    }
                    return bl ? IntRgbxD3D_RTT : IntRgbxD3D;
                }
                return bl ? ThreeByteBgrD3D_RTT : ThreeByteBgrD3D;
            }
            case 15: {
                return bl ? Ushort555RgbD3D_RTT : Ushort555RgbD3D;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getBlueMask() == 62) {
                    return bl ? Ushort555RgbxD3D_RTT : Ushort555RgbxD3D;
                }
                return bl ? Ushort565RgbD3D_RTT : Ushort565RgbD3D;
            }
        }
        throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
    }

    private native int initOffScreenSurface(long var1, long var3, long var5, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int initSurface(int n, int n2, int n3, Win32SurfaceData win32SurfaceData) {
        int n4 = 0;
        Object object = D3DContext.LOCK;
        synchronized (object) {
            D3DContext d3DContext;
            long l;
            long l2 = this.getNativeOps();
            long l3 = 0L;
            if (win32SurfaceData != null) {
                l3 = win32SurfaceData.getNativeOps();
            }
            if ((l = (d3DContext = this.getContext()).getNativeContext()) == 0L) {
                d3DContext.reinitNativeContext();
                l = d3DContext.getNativeContext();
            }
            if (l2 == 0L || l == 0L) {
                throw new InvalidPipeException("D3DSD.initSurface: pData or pCtx is null");
            }
            n4 = this.initOffScreenSurface(l, l2, l3, n, n2, this.type, n3);
        }
        return n4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void validatePipe(SunGraphics2D var1_1) {
        block8: {
            block5: {
                block7: {
                    block6: {
                        if (var1_1.compositeState >= 2) break block5;
                        var3_2 = false;
                        if (var1_1.compositeState > 0) break block6;
                        if (var1_1.paintState <= 1) break block7;
                    }
                    if (var1_1.compositeState != 1) ** GOTO lbl-1000
                    if (var1_1.paintState > 1 || ((AlphaComposite)var1_1.composite).getRule() != 3) ** GOTO lbl-1000
                }
                if (var1_1.textAntialiasHint <= 3) {
                    var2_3 /* !! */  = D3DSurfaceData.d3dTextPipe;
                } else lbl-1000:
                // 3 sources

                {
                    super.validatePipe(var1_1);
                    var2_3 /* !! */  = var1_1.textpipe;
                    var3_2 = true;
                }
                if (var1_1.antialiasHint == 2) ** GOTO lbl-1000
                if (var1_1.paintState <= 1) {
                    var1_1.drawpipe = var1_1.strokeState == 0 ? D3DSurfaceData.d3dPipe : D3DSurfaceData.d3dTxPipe;
                    var1_1.fillpipe = D3DSurfaceData.d3dPipe;
                    var1_1.shapepipe = D3DSurfaceData.d3dPipe;
                } else if (!var3_2) {
                    super.validatePipe(var1_1);
                }
                var1_1.textpipe = var2_3 /* !! */ ;
                break block8;
            }
            super.validatePipe(var1_1);
        }
        var1_1.imagepipe = D3DSurfaceData.d3dDrawImagePipe;
    }

    public void disableD3D() {
        this.markSurfaceLost();
        SurfaceManager surfaceManager = SurfaceManager.getManager(this.image);
        if (surfaceManager instanceof WinVolatileSurfaceManager) {
            ((WinVolatileSurfaceManager)surfaceManager).setD3DAccelerationEnabled(false);
        }
    }

    public boolean surfacePunted() {
        return false;
    }

    D3DContext getContext() {
        return ((Win32GraphicsDevice)this.graphicsConfig.getDevice()).getD3DContext();
    }

    static {
        if (WindowsFlags.isD3DEnabled()) {
            D3DBlitLoops.register();
            D3DMaskFill.register();
        }
        d3dPipe = new D3DRenderer();
        d3dTxPipe = new PixelToShapeConverter(d3dPipe);
        d3dTextPipe = new D3DTextRenderer();
        d3dDrawImagePipe = new D3DDrawImage();
        if (GraphicsPrimitive.tracingEnabled()) {
            d3dPipe = d3dPipe.traceWrapD3D();
            d3dTextPipe = d3dTextPipe.traceWrap();
        }
    }
}

