/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnNull;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnObjectId;
import cryptix.jce.provider.asn.AsnSequence;
import cryptix.jce.provider.asn.AsnUnknown;
import cryptix.jce.provider.asn.SubInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class AsnInputStream {
    private final InputStream is;

    public AsnObject read() throws IOException {
        int tagAsInt = this.is.read();
        if (tagAsInt == -1) {
            throw new IOException("End of stream.");
        }
        byte tag = (byte)tagAsInt;
        switch (tag) {
            case 6: {
                return new AsnObjectId(this);
            }
            case 3: {
                return new AsnBitString(this);
            }
            case 2: {
                return new AsnInteger(this);
            }
            case 5: {
                return new AsnNull(this);
            }
            case 48: {
                return new AsnSequence(this);
            }
        }
        return new AsnUnknown(tag, this);
    }

    public int available() throws IOException {
        return this.is.available();
    }

    int readLength() throws IOException {
        int b = this.is.read();
        if (b == -1) {
            throw new IOException("Unexpected end of stream.");
        }
        if (b <= 127) {
            return b;
        }
        if ((b &= 0x7F) > 4) {
            throw new IOException("Length too big.");
        }
        int res = 0;
        while (b-- > 0) {
            int t = this.is.read();
            if (t == -1) {
                throw new IOException("Unexpected end of stream.");
            }
            res = res << 8 | t;
        }
        if (res < 0) {
            throw new IOException("Negative length.");
        }
        return res;
    }

    byte readByte() throws IOException {
        return this.readBytes(1)[0];
    }

    byte[] readBytes(int todo) throws IOException {
        byte[] res = new byte[todo];
        int off = 0;
        while (todo > 0) {
            int done = this.is.read(res, off, todo);
            if (done == -1) {
                throw new IOException("EOF");
            }
            todo -= done;
            off += done;
        }
        return res;
    }

    AsnInputStream getSubStream(int len) {
        return new AsnInputStream(new SubInputStream(this.is, len));
    }

    public AsnInputStream(byte[] data) {
        this.is = new ByteArrayInputStream(data);
    }

    public AsnInputStream(InputStream is) {
        this.is = is;
    }
}

