/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.downloadmgr;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import com.adventnet.sym.server.downloadmgr.DownloadStatus;
import com.adventnet.sym.server.downloadmgr.SSLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadManager {
    private Logger logger = Logger.getLogger("DownloadManager");
    public static DownloadManager dwnmgr = null;
    private Properties proxydetails = null;

    public static DownloadManager getInstance() {
        if (dwnmgr == null) {
            dwnmgr = new DownloadManager();
        }
        return dwnmgr;
    }

    public void setProxyConfiguration(Properties proxyProp) {
        this.proxydetails = proxyProp;
    }

    public boolean TestConnection(Properties proxyProp) throws IOException, ModuleException {
        String rspContentType;
        int status;
        boolean returnStatus = false;
        HTTPResponse response = null;
        String sourceFile = "https://sync.patchquest.com/crs/testsample.exe";
        response = this.getHttpResponse(sourceFile, null, this.proxydetails, null);
        if (response != null && (status = response.getStatusCode()) >= 200 && status < 400 && (rspContentType = response.getHeader("Content-Type")) != null && rspContentType.indexOf("text/") == -1) {
            returnStatus = true;
        }
        return returnStatus;
    }

    public DownloadStatus downloadFile(String sourceFile, String destinationFile) {
        return this.downloadFile(sourceFile, destinationFile, null, null, false);
    }

    public DownloadStatus downloadFile(String sourceFile, String destinationFile, Properties formdata) {
        return this.downloadFile(sourceFile, destinationFile, formdata, null, false);
    }

    public DownloadStatus GetFileDataBuffer(String sourceFile, Properties postformdata) {
        return this.downloadData(sourceFile, postformdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadStatus downloadFile(String sourceFile, String destinationFile, Properties postformdata, Properties headers, boolean isBinary) {
        String errorMessage;
        int returnStatus;
        block39: {
            InputStream in = null;
            boolean continueDownload = true;
            HTTPResponse response = null;
            returnStatus = 10008;
            errorMessage = "";
            try {
                this.logger.log(Level.INFO, "Going to establish connecton for " + sourceFile);
                String userAgent = System.getProperty("http.agent");
                if (userAgent == null) {
                    userAgent = "ManageEngine Desktop Central";
                }
                if (headers == null) {
                    headers = new Properties();
                }
                if (!headers.containsKey("User-Agent")) {
                    headers.put("User-Agent", userAgent);
                }
                if ((response = this.getHttpResponse(sourceFile, postformdata, this.proxydetails, headers)) != null) {
                    int httpstatus = response.getStatusCode();
                    if (httpstatus >= 200 && httpstatus < 400) {
                        String rspContentType;
                        if (isBinary && (rspContentType = response.getHeader("Content-Type")) != null && rspContentType.indexOf("text/") != -1) {
                            continueDownload = false;
                        }
                        if (!continueDownload) break block39;
                        in = response.getInputStream();
                        try {
                            if (in != null) {
                                this.logger.log(Level.INFO, "Reading the stream of the url ...{0}", sourceFile);
                                for (int loopCounter = 0; in.available() < 1 && loopCounter < 6; ++loopCounter) {
                                    Thread.sleep(10000L);
                                }
                            }
                        }
                        catch (InterruptedException iex) {
                            this.logger.log(Level.INFO, "The Patch Download thread in sleep exception : {0}", iex.getMessage());
                        }
                        if (in != null && in.available() > 0) {
                            if (destinationFile != null) {
                                this.writeFile(in, destinationFile);
                                returnStatus = 0;
                            }
                        } else {
                            this.logger.log(Level.INFO, "The in stream is empty for the url {0}", sourceFile);
                        }
                        break block39;
                    }
                    if (httpstatus == 403) {
                        returnStatus = httpstatus;
                        errorMessage = "The request is forbidden.Http Status Code :: 403";
                    } else {
                        this.logger.log(Level.WARNING, "The http status code returned from web server : {0}", new Integer(httpstatus));
                        errorMessage = "The http status code returned from web server : " + new Integer(httpstatus);
                    }
                    break block39;
                }
                this.logger.log(Level.WARNING, "The received response is null for the source url : {0}", sourceFile);
                errorMessage = "The received response is null for the source url : " + sourceFile;
            }
            catch (ProtocolNotSuppException pnse) {
                this.logger.log(Level.WARNING, "Error occurred while reading & writing : {0} : {1}", new Object[]{sourceFile, pnse});
                errorMessage = pnse.getMessage();
            }
            catch (FileNotFoundException fexp) {
                this.logger.log(Level.WARNING, "Error occurred while writing to the file : {0} : {1}", new Object[]{destinationFile, fexp});
                errorMessage = fexp.getMessage();
            }
            catch (IOException ex) {
                this.logger.log(Level.WARNING, "Error occurred while reading & writing : {0} : {1}", new Object[]{destinationFile, ex});
                errorMessage = ex.getMessage();
            }
            catch (Exception exp) {
                this.logger.log(Level.WARNING, "Runtime Exception has been occurred while downloading : {0} : {1}", new Object[]{destinationFile, exp});
                errorMessage = exp.getMessage();
                exp.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Error while closing input streams {0}", ex);
                }
            }
        }
        DownloadStatus status = new DownloadStatus(returnStatus, errorMessage);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadStatus downloadData(String sourceFile, Properties postformdata) {
        int returnStatus;
        String errorMessage;
        String responseBuffer;
        block23: {
            InputStream in = null;
            HTTPResponse response = null;
            responseBuffer = null;
            errorMessage = "";
            returnStatus = 10008;
            try {
                response = this.getHttpResponse(sourceFile, postformdata, this.proxydetails, null);
                if (response == null) break block23;
                int httpstatus = response.getStatusCode();
                if (httpstatus >= 200 && httpstatus < 400) {
                    in = response.getInputStream();
                    try {
                        if (in != null) {
                            this.logger.log(Level.INFO, "Reading the stream of the source url ...{0}", sourceFile);
                            for (int loopCounter = 0; in.available() < 1 && loopCounter < 6; ++loopCounter) {
                                Thread.sleep(10000L);
                            }
                        }
                    }
                    catch (InterruptedException iex) {
                        this.logger.log(Level.WARNING, "The Patch Download thread in sleep exception : {0}", iex);
                    }
                    if (in != null && in.available() > 0) {
                        responseBuffer = this.readDataBufferFromStream(in);
                        returnStatus = 0;
                    } else {
                        this.logger.log(Level.INFO, "The in stream is empty for the url {0}", sourceFile);
                    }
                    break block23;
                }
                this.logger.log(Level.WARNING, "The http status code returned from web server : {0}", new Integer(httpstatus));
                errorMessage = "The http status code returned from web server : " + new Integer(httpstatus);
            }
            catch (IOException ex) {
                this.logger.log(Level.WARNING, "Error occurred while reading source file : {0} : {1}", new Object[]{sourceFile, ex});
                errorMessage = ex.getMessage();
            }
            catch (Exception exp) {
                this.logger.log(Level.WARNING, "Runtime Exception has been occurred while reading source file : {0} : {1}", new Object[]{sourceFile, exp});
                errorMessage = exp.getMessage();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Error occurred while closing input streams {0}", ex);
                }
            }
        }
        DownloadStatus status = new DownloadStatus(returnStatus, errorMessage);
        status.setUrlDataBuffer(responseBuffer);
        return status;
    }

    private HTTPResponse getHttpResponse(String sourceFile, Properties postformdata, Properties proxydetails, Properties headers) throws ProtocolNotSuppException, MalformedURLException, IOException, ModuleException {
        HTTPResponse response = null;
        HTTPConnection connection = null;
        if (sourceFile != null) {
            SSLUtil sslutil = SSLUtil.getInstance();
            URL url = new URL(sourceFile);
            connection = sslutil.getConnection(sourceFile, proxydetails);
            if (postformdata != null) {
                NVPair[] nvpairs = this.getPostFormData(postformdata);
                NVPair[] headersNVPair = null;
                if (headers != null) {
                    headersNVPair = this.getPostFormData(headers);
                }
                response = nvpairs != null ? connection.Get(url.getFile(), nvpairs, headersNVPair) : connection.Get(url.getFile());
            } else {
                response = connection.Get(url.getFile());
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(InputStream in, String destinationFile) throws IOException, FileNotFoundException, Exception {
        FileOutputStream outFile = null;
        try {
            if (destinationFile != null) {
                int len;
                File fname = new File(destinationFile).getParentFile();
                if (!fname.exists()) {
                    fname.mkdirs();
                }
                outFile = new FileOutputStream(destinationFile);
                byte[] buf = new byte[8192];
                while ((len = in.read(buf)) != -1) {
                    outFile.write(buf, 0, len);
                }
                this.logger.log(Level.INFO, "Writing completed for the file : {0}", destinationFile.replace("\\", "\\\\"));
            }
        }
        finally {
            try {
                if (outFile != null) {
                    outFile.close();
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error occurred while closing output stream  {0}", ex);
            }
        }
    }

    private String readDataBufferFromStream(InputStream in) throws IOException {
        int len;
        String responseBuffer = "";
        StringBuilder sbuffer = new StringBuilder();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            sbuffer.append(buf);
        }
        responseBuffer = sbuffer.toString();
        return responseBuffer;
    }

    private NVPair[] getPostFormData(Properties formdata) {
        int size;
        NVPair[] post_form_data = null;
        if (formdata != null && (size = formdata.size()) > 0) {
            int position = 0;
            post_form_data = new NVPair[size];
            Enumeration<Object> iterate = formdata.keys();
            while (iterate.hasMoreElements()) {
                String key = (String)iterate.nextElement();
                String value = (String)formdata.get(key);
                post_form_data[position] = new NVPair(key, value);
            }
        }
        return post_form_data;
    }
}

