/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import cryptix.jce.provider.dsa.SignatureData;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public final class DSASignature
extends SignatureSpi
implements Cloneable {
    private static final SecureRandom _fallbackRng = new SecureRandom();
    private static final boolean MODE_SIGN = false;
    private static final boolean MODE_VERIFY = true;
    private final MessageDigest _md;
    private BigInteger _g;
    private BigInteger _p;
    private BigInteger _q;
    private BigInteger _exp;

    public Object clone() throws CloneNotSupportedException {
        return new DSASignature(this);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("No params supported.");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, _fallbackRng);
    }

    protected void engineInitSign(PrivateKey privKey, SecureRandom random) throws InvalidKeyException {
        if (!(privKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Not a DSA private key");
        }
        DSAPrivateKey dsaPrivKey = (DSAPrivateKey)privKey;
        this._exp = dsaPrivKey.getX();
        DSAParams params = dsaPrivKey.getParams();
        this._g = params.getG();
        this._p = params.getP();
        this._q = params.getQ();
        this.appRandom = random;
        this._md.reset();
        if (!this._isValid(false)) {
            this._clear();
            throw new InvalidKeyException("Corrupt key?");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] engineSign() throws SignatureException {
        void s;
        BigInteger bigInteger;
        BigInteger r;
        BigInteger data = new BigInteger(1, this._md.digest());
        do {
            void k;
            BigInteger bigInteger2;
            int qBitLen = this._q.bitLength();
            while ((bigInteger2 = new BigInteger(qBitLen, this.appRandom)).compareTo(this._q) != -1) {
            }
            r = this._g.modPow((BigInteger)k, this._p).mod(this._q);
            bigInteger = k.modInverse(this._q).multiply(data.add(this._exp.multiply(r))).mod(this._q);
        } while (r.equals(BigInteger.ZERO) || bigInteger.equals(BigInteger.ZERO));
        return new SignatureData(r, (BigInteger)s).getData();
    }

    protected int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] sigBytes = this.engineSign();
        if (sigBytes.length > len) {
            throw new SignatureException("Buffer too small.");
        }
        System.arraycopy(sigBytes, 0, outbuf, offset, sigBytes.length);
        return sigBytes.length;
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this._md.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this._md.update(b, off, len);
    }

    protected void engineInitVerify(PublicKey pubKey) throws InvalidKeyException {
        if (!(pubKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Not a DSA public key");
        }
        DSAPublicKey dsaPubKey = (DSAPublicKey)pubKey;
        this._exp = dsaPubKey.getY();
        DSAParams dsaParams = dsaPubKey.getParams();
        this._g = dsaParams.getG();
        this._p = dsaParams.getP();
        this._q = dsaParams.getQ();
        this.appRandom = null;
        this._md.reset();
        if (!this._isValid(true)) {
            this._clear();
            throw new InvalidKeyException("Corrupt key?");
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        SignatureData sigData = new SignatureData(sigBytes);
        BigInteger r = sigData.getR();
        BigInteger s = sigData.getS();
        if (r.compareTo(BigInteger.ZERO) != 1 || r.compareTo(this._q) != -1 || s.compareTo(BigInteger.ZERO) != 1 || s.compareTo(this._q) != -1) {
            throw new SignatureException("Invalid signature data");
        }
        BigInteger data = new BigInteger(1, this._md.digest());
        if (data.bitLength() > 160) {
            throw new InternalError("PANIC");
        }
        BigInteger w = s.modInverse(this._q);
        BigInteger u1 = data.multiply(w).mod(this._q);
        BigInteger u2 = r.multiply(w).mod(this._q);
        BigInteger gu1 = this._g.modPow(u1, this._p);
        BigInteger yu2 = this._exp.modPow(u2, this._p);
        BigInteger v = gu1.multiply(yu2).mod(this._p).mod(this._q);
        if (w.compareTo(this._q) != -1) {
            throw new InternalError("PANIC");
        }
        if (v.compareTo(this._q) != -1) {
            throw new InternalError("PANIC");
        }
        if (u1.compareTo(this._q) != -1) {
            throw new InternalError("PANIC");
        }
        if (u2.compareTo(this._q) != -1) {
            throw new InternalError("PANIC");
        }
        if (gu1.compareTo(this._p) != -1) {
            throw new InternalError("PANIC");
        }
        if (yu2.compareTo(this._p) != -1) {
            throw new InternalError("PANIC");
        }
        return v.equals(r);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No params supported.");
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("No params supported.");
    }

    private void _clear() {
        this.appRandom = null;
        this._exp = null;
        this._q = null;
        this._p = null;
        this._g = null;
        this._md.reset();
    }

    private boolean _isValid(boolean mode) {
        int pLen = this._p.bitLength();
        if (pLen > 1024 || pLen < 512 || pLen % 64 != 0) {
            return false;
        }
        if (this._q.bitLength() != 160) {
            return false;
        }
        if (this._g.compareTo(this._p) != -1) {
            return false;
        }
        if (this._exp == null || this._exp.compareTo(this._p) != -1) {
            return false;
        }
        return this.appRandom == null == mode;
    }

    public DSASignature() {
        try {
            this._md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("PANIC: Algorithm SHA not found!");
        }
    }

    private DSASignature(DSASignature srcSig) throws CloneNotSupportedException {
        this._md = (MessageDigest)srcSig._md.clone();
        this._g = srcSig._g;
        this._p = srcSig._p;
        this._q = srcSig._q;
        this._exp = srcSig._exp;
    }
}

