/*$Id: DownloadStatus.java,v 1.2 2011/09/03 07:24:51 mathankarthik.r Exp $*/
package com.adventnet.sym.server.downloadmgr;

/**
 *
 * @author rajeshr
 */
public class DownloadStatus {

    int dwnloadstatus;
    String errMessage = "";
    String dataBuffer;

    /**
     * This constructor is used to populate  the download status and the error message.
     * @param dwnstatus - The DownloadConstant value is updated accordingly for the response.
     * @param errorMessage - The message has been constructed and populated. This can be used
     * for sending back the informations to the end users.
     */
    public DownloadStatus(int dwnstatus, String errorMessage) {
        this.dwnloadstatus = dwnstatus;
        this.errMessage = errorMessage;
    }

    /**
     * This constructor is used to populate the download status.
     * @param dwnstatus - The DownloadConstant value is updated accordingly for the response.
     */
    DownloadStatus(int dwnstatus) {
        this.dwnloadstatus = dwnstatus;
    }

    /**
     * This is the getter method to return the download status of a download request.
     * @return
     */
    public int getStatus() {
        return dwnloadstatus;
    }

    /**
     * This method is the getter method to return the error message of a download request.
     * @return
     */
    public String getErrorMessage() {
        return errMessage;
    }

    /**
     * This method is the setter method to update the download status which can be used for
     * checking whether the download has been completed successfully or not.
     * @param dwnstatus -  The DownloadConstant value is updated accordingly for the response.
     */
    public void setStatus(int dwnstatus) {
        this.dwnloadstatus = dwnstatus;
    }

    /**
     * This method is the setter method to update the error message occurred during the download
     * of file.
     * @param errorMessage - The message has been constructed and populated. This can be used
     * for sending back the informations to the end users.
     */
    public void setErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            this.errMessage = errorMessage;
        }
    }

    /**
     * This method is used to return the data for the url fetched.
     * @return - dataBuffer url data.
     */

    public String getUrlDataBuffer(){
        return dataBuffer;
    }
/**
 * This method is used to set the read url data buffer in DownloadStatus.
 * @param dataBuffer
 */
    public void setUrlDataBuffer(String dataBuffer){
        this.dataBuffer = dataBuffer;
    }
}

